/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.gamestate;

import com.work4games.audio.AudioPlayer;
import com.work4games.gamestate.GameState;
import com.work4games.gamestate.MenuState;
import com.work4games.gamestate.PlayState;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.io.IOException;

public class GameStateManager {
    private GameState[] gameStates;
    private static int currentState;
    public Font font;
    public Font pixelFont22;
    public Font pixelFont20;
    public Font pixelFont16;
    public Font pixelFont14;
    public static final int NUMGAMESTATES = 2;
    public static final int MENUSTATE = 0;
    public static final int PLAYSTATE = 1;

    public GameStateManager() throws IOException {
        try {
            this.font = new Font("Arial", 0, 22);
            this.pixelFont22 = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")).deriveFont(22.0f);
            this.pixelFont20 = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")).deriveFont(20.0f);
            this.pixelFont16 = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")).deriveFont(16.0f);
            this.pixelFont14 = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")).deriveFont(14.0f);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")));
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")));
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")));
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        AudioPlayer.init();
        this.gameStates = new GameState[2];
        currentState = 1;
        this.loadState(currentState);
    }

    private void loadState(int state) {
        if (state == 0) {
            this.gameStates[state] = new MenuState(this);
        }
        if (state == 1) {
            this.gameStates[state] = new PlayState(this);
        }
    }

    private void unloadState(int state) {
        this.gameStates[state] = null;
    }

    public void setState(int state) {
        this.unloadState(currentState);
        currentState = state;
        this.loadState(currentState);
        this.gameStates[currentState].init();
    }

    public void update() {
        if (this.gameStates[currentState] == null) {
            return;
        }
        this.gameStates[currentState].update();
    }

    public void draw(Graphics2D g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, 640, 480);
        if (this.gameStates[currentState] == null) {
            return;
        }
        this.gameStates[currentState].draw(g);
        g.setColor(Color.gray);
        g.setFont(this.font);
    }

    public void drawCenteredString(String s, int w, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int x = (w * 2 - fm.stringWidth(s)) / 2;
        int y = fm.getAscent() + (h * 2 - (fm.getAscent() + fm.getDescent())) / 2;
        g.drawString(s, x, y);
    }

    public static int getState() {
        return currentState;
    }
}

